; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10

;---|  |---------------------------------------------------------------
[Command]
name = "holdx"	  
command = /x
time = 1

[Command]
name = "holdy"	  
command = /y
time = 1

[Command]
name = "holdz"	  
command = /z
time = 1

[Command]
name = "holda"	   
command = /a
time = 1
;-|  |-----------------------------------------------------------------

[Command]
name = "recovery" ;K{R}h
command = x+y
time = 1

[Command]
name = "x+y+z"
command = x+y+z

[Command]
name = "x+y+a+b"
command = x+y+a+b

[Command]
name = "z+a"
command = z+a
time = 1

[Command]
name = "x+a"
command = x+a
time = 1

[Command]
name = "y+a"
command = y+a
time = 1

[Command]
name = "b+a"
command = b+a
time = 1
;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
[Command]
name = "syutugen"
command = ~D, DF, F, a

[Command]
name = "ryaku"
command = ~D, DF, F, b

[Command]
name = "ryaku2"
command = ~D, DB, B, b

[Command]
name = "ryaku3"
command = ~B, DB, D, DF, F, b

[Command]
name = "sin"
command = ~B, DB, D, DF, F, x+y

[Command]
name = "kurawasero"
command = ~D, DB, B, x+y
time = 20

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, x+y
time = 20

[Command]
name = "TripleKFPalm"   ;Same name as above
command = ~D, DF, F, D, DF, F, y
time = 20

[Command]
name = "SmashKFUpper"
command = ~D, DB, B, D, DB, B, x;~F, D, DF, F, D, DF, x
time = 20

[Command]
name = "SmashKFUpper"   ;Same name as above
command = ~D, DB, B, D, DB, B, y;~F, D, DF, F, D, DF, y
time = 20

[Command]
name = "tandem"
command = ~D, B, a
time = 20

;-| Special Motions |------------------------------------------------------
[Command]
name = "sp1"
command = ~B, DB, D, DF, F, x

[Command]
name = "sp2"
command = ~B, DB, D, DF, F, y

[Command]
name = "sp3"
command = ~B, DB, D, DF, F, z

[Command]
name = "upper_x"
command = ~F, D, DF, x

[Command]
name = "upper_y"
command = ~F, D, DF, y

[Command]
name = "upper_z"
command = ~F, D, DF, z

[Command]
name = "upper_xy"
command = ~F, D, DF, x+y

[Command]
name = "hattari"
command = ~D, DF, F, c

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_z"
command = ~D, DF, F, z

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

[Command]
name = "QCB_x"
command = ~D, DB, B, x

[Command]
name = "QCB_y"
command = ~D, DB, B, y

[Command]
name = "QCB_z"
command = ~D, DB, B, z

[Command]
name = "QCB_xy"
command = ~D, DB, B, x+y

[Command]
name = "FF_ab"
command = F, F, a+b

[Command]
name = "FF_a"
command = F, F, a

[Command]
name = "FF_b"
command = F, F, b

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "xyz";Required (do not remove)
command = x+y+z
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "up"
command = $U
time = 1

[Command]
name = "upc"
command = ~$U ;$Ƃ
time = 1


;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holda"
command = /$a
time = 1

[Command]
name = "holdx"
command = /$x
time = 1

[Command]
name = "holdy"
command = /$y
time = 1
;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
;===========================================================================
;^EBXon
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 13100
triggerall = numhelper(10011) = 0
triggerall = var(49) = 10000
triggerall = command = "sin"
triggerall = power >= 3000
triggerall = statetype != A
trigger1 = ctrl

;^EBXonB
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 13100
triggerall = numhelper(10011) = 0
triggerall = var(49) = 10000
triggerall = command = "ryaku3"
triggerall = power >= 3000
triggerall = statetype != A
trigger1 = ctrl
;===========================================================================
;킹Ion
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 13050
triggerall = numhelper(10011) = 0
triggerall = var(49) = 10000
triggerall = command = "kurawasero"
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl

;킹Ion
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 13050
triggerall = numhelper(10011) = 0
triggerall = var(49) = 10000
triggerall = command = "ryaku2"
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl

;킹I
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 3050
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = numhelper(2) = 0
triggerall = command = "kurawasero"
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl

;킹I
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 3050
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = numhelper(2) = 0
triggerall = command = "ryaku2"
triggerall = power >= 2000
triggerall = statetype != A
trigger1 = ctrl
;---------------------------------------------------------------------------
;h]bI on
[State -1, Triple Kung Fu Palm]
type = ChangeState
value = 13000
triggerall = var(49) = 10000
triggerall = command = "TripleKFPalm"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 10210) && movecontact
trigger3 = (stateno = 10212) && movecontact
trigger4 = (stateno = 10215) && movecontact
trigger5 = (stateno = 10420) && movecontact
trigger6 = (stateno = 10422) && movecontact
trigger7 = (stateno = 10425) && movecontact
trigger8 = (stateno = 11050) && time > 15

;h]bI on
[State -1, Triple Kung Fu Palm]
type = ChangeState
value = 13000
triggerall = var(49) = 10000
triggerall = command = "ryaku"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 10210) && movecontact
trigger3 = (stateno = 10212) && movecontact
trigger4 = (stateno = 10215) && movecontact
trigger5 = (stateno = 10420) && movecontact
trigger6 = (stateno = 10422) && movecontact
trigger7 = (stateno = 10425) && movecontact
trigger8 = (stateno = 11050) && time > 15

;h]bI
[State -1, Triple Kung Fu Palm]
type = ChangeState
value = 3000
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = command = "TripleKFPalm"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 215) && movehit

;h]bIB
[State -1, Triple Kung Fu Palm]
type = ChangeState
value = 3000
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = command = "ryaku"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 8
trigger4 = (stateno = 215) && movehit
;---------------------------------------------------------------------------
[State -1, f];X^hoff
type = ChangeState
value = 3900
triggerall = numhelper(4657) = 0
triggerall = numhelper(2) = 0
triggerall = command = "tandem"
triggerall = power >= 1000
triggerall = var(43) = 0  
triggerall = var(49) = 0  ;X^hoff̎
triggerall = NumHelper(2) = 0 
trigger1 = numhelper(11011) = 0
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = numhelper(11011) = 0
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 9
trigger4 = (stateno = 212) && movecontact
trigger5 = (stateno = 245) && movecontact

[State -1, f];X^hon
type = ChangeState
value = 3900
triggerall = stateno != 14000
triggerall = var(43) = 0  
triggerall = numhelper(4657) = 0
triggerall = command = "tandem"
triggerall = power >= 1000
triggerall = var(49) = 10000  ;X^hon̎
triggerall = NumHelper(2) = 0 
triggerall = NumHelper(11010) = 0 
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA ;Ⴊ݂̒ʏU(񂹂܂)
trigger2 = movecontact
trigger3 = (stateno = 11050) && time > 15
;===========================================================================
;Strong Kung Fu Upper
;ႤˁI ON
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 11200
triggerall = var(49) = 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "sp1"
trigger1 = ctrl
trigger2 = (stateno = 10210) && movecontact
trigger3 = (stateno = 11050) && time > 15

;ႤˁI
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1200
triggerall = numhelper(4657) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "sp1"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 9

;Strong Kung Fu Upper
;ႤˁIB
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1200
triggerall = numhelper(4657) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = statetype != A
triggerall = command = "sp1"
trigger1 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;Strong Kung Fu Upper
;ႤˁI2 ON
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 11210
triggerall = var(49) = 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "sp2"
trigger1 = ctrl
trigger2 = (stateno = 10210) && movecontact
trigger3 = (stateno = 11050) && time > 15

;ႤˁI2
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1210
triggerall = numhelper(4657) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "sp2"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 9

;Strong Kung Fu Upper
;ႤˁI2B
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1210
triggerall = numhelper(4657) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = statetype != A
triggerall = command = "sp2"
trigger1 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;Strong Kung Fu Upper
;ႤˁI3 ON
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 11220
triggerall = var(49) = 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "sp3"
trigger1 = ctrl
trigger2 = (stateno = 10210) && movecontact
trigger3 = (stateno = 11050) && time > 15

;ႤˁI3
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1220
triggerall = numhelper(4657) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "sp3"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 9

;Strong Kung Fu Upper
;ႤˁI3B
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1220
triggerall = numhelper(4657) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = statetype != A
triggerall = command = "sp3"
trigger1 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;wCY΋ on@
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 11100
triggerall = power >= 500
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "upper_x"
trigger1 = ctrl
trigger2 = (stateno = 10410) && movecontact
trigger3 = (stateno = 10412) && movecontact

;wCY΋ on 
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 11110
triggerall = power >= 500
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall= command = "upper_y"
trigger1 = ctrl
trigger2 = (stateno = 10410) && movecontact
trigger3 = (stateno = 10412) && movecontact

;wCY΋ on@
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 11120
triggerall = power >= 500
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "upper_z"
trigger1 = ctrl
trigger2 = (stateno = 10410) && movecontact
trigger3 = (stateno = 10412) && movecontact
;---------------------------------------------------------------------------
;wCY΋
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1100
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "upper_z"
trigger1 = ctrl
;---------------------------------------------------------------------------
;Light Kung Fu Upper
;wCY΋
[State -1, Light Kung Fu Upper]
type = ChangeState
value = 1100
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "upper_x"
trigger1 = ctrl
;---------------------------------------------------------------------------
;Strong Kung Fu Upper
;wCY΋
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1100
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "upper_y"
trigger1 = ctrl
;---------------------------------------------------------------------------
;ElEBXinb^jnm
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11050
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "hattari"
trigger1 = ctrl

;ElEBXairnm
[State -1, Fast Kung Fu Upper]
type = ChangeState
triggerall = power >= 500
value = 11500
triggerall = numhelper(11011) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype = A
triggerall = command = "QCF_x"
trigger1 = ctrl

;ElEBXnm
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11000
triggerall = power >= 500
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "QCF_x"
trigger1 = ctrl

;ElEBXair
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1500
triggerall = numhelper(11011) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 0
triggerall = statetype = A
triggerall = command = "QCF_x"
trigger1 = ctrl

;ElEBX
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1000
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "QCF_x"
trigger1 = ctrl

;Strong Kung Fu Upper
;ElEBXB
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1000
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = statetype != A
triggerall = command = "QCF_x"
trigger1 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;ElEBX2nm
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11000
triggerall = power >= 500
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "QCF_y"
trigger1 = ctrl

;ElEBXair2nm
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11500
triggerall = power >= 500
triggerall = numhelper(11011) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype = A
triggerall = command = "QCF_y"
trigger1 = ctrl

;ElEBX2air
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1500
triggerall = numhelper(11011) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 0
triggerall = statetype = A
triggerall = command = "QCF_y"
trigger1 = ctrl

;ElEBX2
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1000
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "QCF_y"
trigger1 = ctrl
trigger2 = (stateno = 245) && movecontact

;Strong Kung Fu Upper
;ElEBXB2
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1000
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = statetype != A
triggerall = command = "QCF_y"
trigger1 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;ElEBX3nm
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11000
triggerall = power >= 500
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "QCF_z"
trigger1 = ctrl

;ElEBXair3nm
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11500
triggerall = power >= 500
triggerall = numhelper(11011) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = statetype = A
triggerall = command = "QCF_z"
trigger1 = ctrl

;ElEBX3air
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1500
triggerall = numhelper(11011) = 0
triggerall = numhelper(10011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) = 0
triggerall = statetype = A
triggerall = command = "QCF_z"
trigger1 = ctrl

;ElEBX3
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1000
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "QCF_z"
trigger1 = ctrl
trigger2 = (stateno = 245) && movecontact

;Strong Kung Fu Upper
;ElEBXB3
[State -1, Strong Kung Fu Upper]
type = ChangeState
value = 1000
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = statetype != A
triggerall = command = "QCF_z"
trigger1 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;񂾁ION
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11300
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "QCB_x"
triggerall = numhelper(11308) = 0
trigger1 = ctrl
trigger2 = (stateno = 10210) && time > movecontact
trigger3 = (stateno = 11050) && time > 15

;񂾁I
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1300
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "QCB_x"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 9
trigger4 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;񂾁ION
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11300
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "QCB_y"
triggerall = numhelper(11308) = 0
trigger1 = ctrl
trigger2 = (stateno = 10210) && time > movecontact
trigger3 = (stateno = 11050) && time > 15

;񂾁I
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1300
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "QCB_y"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 9
trigger4 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;񂾁ION
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 11300
triggerall = var(49) = 10000
triggerall = statetype != A
triggerall = command = "QCB_z"
triggerall = numhelper(11308) = 0
trigger1 = ctrl
trigger2 = (stateno = 10210) && time > movecontact
trigger3 = (stateno = 11050) && time > 15

;񂾁I
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1300
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = statetype != A
triggerall = command = "QCB_z"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5 
trigger3 = (stateno = 210) && time > 9
trigger4 = (stateno = 245) && movecontact
;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;K[L
[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1800
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = numhelper(2) = 0
triggerall = statetype != A
trigger1 = command = "QCF_x" || command = "QCF_y" || command = "QCF_z"
trigger1 = (stateno = [150,153])
;---------------------------------------------------------------------------
;K[LS
[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 11800
triggerall = var(49) = 10000
triggerall = statetype != A
trigger1 = command = "QCF_x" || command = "QCF_y" || command = "QCF_z"
trigger1 = (stateno = [150,153])
;---------------------------------------------------------------------------
;Kung Fu Throw
;
[State -1, Kung Fu Throw]
type = ChangeState
value = 900
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 3
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 5
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;@on
[State -1, Kung Fu Throw]
type = ChangeState
value = 10900
triggerall = command = "z"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
triggerall = var(49) = 10000
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 3
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 5
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H
;------------------------------------------------------------------------------
[State -1, 荞]
type = ChangeState
triggerall = var(49) != 10000
triggerall = var(10) = 0
triggerall = (RoundState = 2) && (Alive)
trigger1 = statetype != A && ctrl
trigger1 = command = "b"
trigger2 = statetype != A && ctrl
trigger2 = command = "xyz"
value = 30
;---------------------------------------------------------------------------
;AhoVOij
[State -1, Run Back]
type = ChangeState
triggerall = var(49) != 10000
triggerall = NumHelper(4010) = 0 
trigger1 = command = "x+y+z" || command = "b" 
trigger1 = statetype = S
trigger1 = stateno = 150 || stateno = 151
trigger1 = prevstateno != 4000 && prevstateno != 4005
ignorehitpause = 1
value = 4100
;---------------------------------------------------------------------------
;AhoVOiႪ݁j
[State -1, Run Back]
type = ChangeState
triggerall = var(49) != 10000
triggerall = NumHelper(4010) = 0 
trigger1 = command = "x+y+z" || command = "b" 
trigger1 = statetype = C
trigger1 = stateno = 152 || stateno = 153
trigger1 = prevstateno != 4000 && prevstateno != 4005
value = 4105
;---------------------------------------------------------------------------
;AhoVOijS
[State -1, Run Back]
type = ChangeState
triggerall = var(49) = 10000
triggerall = numhelper(4010) = 0
trigger1 = command = "x+y+z" || command = "b" 
trigger1 = statetype = S
trigger1 = stateno = 150 || stateno = 151
trigger1 = prevstateno != 4000 && prevstateno != 4005
ignorehitpause = 1
value = 14100
;---------------------------------------------------------------------------
;AhoVOiႪ݁jS
[State -1, Run Back]
type = ChangeState
triggerall = var(49) = 10000
triggerall = numhelper(4010) = 0
trigger1 = command = "x+y+z" || command = "b" 
trigger1 = statetype = C
trigger1 = stateno = 152 || stateno = 153
trigger1 = prevstateno != 4000 && prevstateno != 4005
value = 14105
;===========================================================================
;X^hoU
[State -1, Stand Strong Punch]
type = ChangeState
value = 14000
triggerall = var(49) != 10000
triggerall = NumHelper(2) = 0 
triggerall = command = "syutugen"
triggerall = command != "holddown"
triggerall = statetype != A
triggerall = NumHelper(11011) = 0 
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA 
trigger2 = time > 8
trigger3 = statetype != A
trigger3 = hitdefattr = SC, NA 
trigger3 = movecontact
trigger4 = stateno = 100
trigger5 = stateno = 105

;X^hoUB
[State -1, Stand Strong Punch]
type = ChangeState
value = 14000
triggerall = var(49) != 10000
triggerall = NumHelper(2) = 0 
triggerall = command = "syutugen"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = stateno = 245 && time > 9
trigger2 = stateno = 410 && time > 9
trigger3 = stateno = 440 && time > 11
;---------------------------------------------------------------------------
;@
[State -1, Stand Strong Punch]
type = ChangeState
value = 10202
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "x+a"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 400) && time > 5
trigger4 = stateno = 100
trigger5 = stateno = 105
trigger6 = stateno = 10205 && movecontact

;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = var(49) != 10000
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 8
trigger3 = stateno = 100
trigger4 = stateno = 105

;p` on
[State -1, Stand Light Punch]
type = ChangeState
value = 10200
triggerall = var(49) = 10000
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 10202 && time > 5
trigger3 = stateno = 10205 && movecontact
trigger4 = (stateno = 11050) && time > 15
trigger5 = stateno = 10405 && movecontact

;_bVon
[State -1, Stand Light Punch]
type = ChangeState
value = 10205
triggerall = var(49) = 10000
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = stateno = [100,105]
;---------------------------------------------------------------------------
;@
[State -1, Stand Strong Punch]
type = ChangeState
value = 10212
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "y+a"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 210) && time > 5
trigger4 = (stateno = 400) && time > 5
trigger5 = (stateno = 410) && time > 5
trigger6 = stateno = 100
trigger7 = stateno = 105

;Stand Strong Punch
;
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = var(49) != 10000
triggerall = stateno != 100
triggerall = stateno != 105
triggerall = numhelper(11011) = 0
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 8
trigger3 = (stateno = 230) && time > 6

;_bVon
[State -1, Stand Light Punch]
type = ChangeState
value = 10215
triggerall = var(49) = 10000
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = stateno = [100,105]

;on
[State -1, Stand Strong Punch]
type = ChangeState
value = 10210
triggerall = numhelper(2) = 0
triggerall = var(49) = 10000
triggerall = stateno != 100
triggerall = stateno != 105
triggerall = numhelper(11011) = 0
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 10200) && time > 5
trigger3 = (stateno = 10202) && time > 5
trigger4 = (stateno = 10400) && movecontact
trigger5 = (stateno = 10402) && movecontact
trigger6 = (stateno = 11050) && time > 18
trigger7 = stateno = 10205 && movecontact
trigger8 = stateno = 10405 && movecontact

;Stand Strong Punch
;_bV
[State -1, Stand Strong Punch]
type = ChangeState
value = 212
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 8
trigger3 = (stateno = 230) && time > 6
trigger4 = stateno = 100
trigger5 = stateno = 105

;Stand Strong Punch
;
[State -1, Stand Strong Punch]
type = ChangeState
value = 215
triggerall = var(49) != 10000
triggerall = numhelper(11011) != 0
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 6
trigger3 = (stateno = 230) && time > 6
;---------------------------------------------------------------------------
;@
[State -1, Stand Strong Punch]
type = ChangeState
value = 10222
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "z+a"
triggerall = command != "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 210) && time > 5
trigger4 = (stateno = 212) && time > 10
trigger5 = (stateno = 400) && movecontact
trigger6 = (stateno = 410) && movecontact
trigger7 = stateno = 100
trigger8 = stateno = 105

;Standing Strong Kick
;
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = var(49) != 10000
triggerall = numhelper(2) = 0
triggerall = numhelper(11011) = 0
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 215) && movecontact

;iwCYj
[State -1, Jump Strong Punch]
type = ChangeState
value = 215
triggerall = var(49) != 10000
triggerall = command = "z"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Son̂Ƃp͗]
type = ChangeState
value = 10220 ;Son
triggerall = command = "x"
triggerall = RoundState = 2
triggerall = var(49) = 10000 && statetype != A
triggerall = P2StateType = S
trigger1 = stateno = 10200 && prevstateno = 10200
trigger1 = time >= 6 || movecontact

;p`2 on
[State -1, Stand Light Punch]
type = ChangeState
value = 10200
triggerall = var(49) = 10000
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = stateno = 10200 && time > 4

;_bVon
[State -1, Stand Light Punch]
type = ChangeState
value = 10225
triggerall = var(49) = 10000
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = stateno = [100,105]

;on
[State -1, Standing Strong Kick]
type = ChangeState
value = 10220
triggerall = var(49) = 10000
triggerall = numhelper(2) = 0
triggerall = numhelper(11011) = 0
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 10200) && time > 5
trigger3 = (stateno = 10210) && time > 8
trigger4 = (stateno = 10212) && movecontact
trigger5 = (stateno = 10402) && movecontact
trigger6 = (stateno = 11050) && time > 18

;Stand Strong Punch
;_bV
[State -1, Stand Strong Punch]
type = ChangeState
value = 245
triggerall = var(49) != 10000
triggerall = numhelper(2) = 0
triggerall = numhelper(11011) = 0
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 100
trigger3 = stateno = 105
;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Ⴊݎ
[State -1, Stand Strong Punch]
type = ChangeState
value = 10402
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "x+a"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 400) && time > 5
trigger4 = stateno = 100
trigger5 = stateno = 105

;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = var(49) != 10000
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = 100
trigger3 = stateno = 105
trigger4 = stateno = 1200 && time > 34
trigger5 = stateno = 1210 && time > 35

;Ⴊݎ_bVon
[State -1, Stand Light Punch]
type = ChangeState
value = 10405
triggerall = var(49) = 10000
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = stateno = [100,105]

;Ⴊݎp`on
[State -1, Crouching Light Punch]
type = ChangeState
value = 10400
triggerall = var(49) = 10000
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = 10400 && time > 4
trigger3 = (stateno = 11050) && time > 18
trigger4 = stateno = 10405 && movecontact
;---------------------------------------------------------------------------
;Ⴊݒ@
[State -1, Stand Strong Punch]
type = ChangeState
value = 10412
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "y+a"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 410) && movecontact
trigger3 = stateno = 100
trigger4 = stateno = 105

;Ⴊݒ@B
[State -1, Stand Strong Punch]
type = ChangeState
value = 10412
triggerall = var(49) != 10000
triggerall = NumHelper(2) = 0 
triggerall = command = "y+a"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = (stateno = 245) && movecontact

;Crouching Strong Punch
;ႪݒiwCYLj
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = NumHelper(2) = 0 
triggerall = NumHelper(11011) = 0 
triggerall = var(49) != 10000
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = 100
trigger3 = stateno = 105

;Crouching Strong Punch
;ႪݒiwCYj
[State -1, Crouching Strong Punch]
type = ChangeState
value = 418
triggerall = var(49) != 10000
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = 100
trigger3 = stateno = 105

;Ⴊݒ_bVon
[State -1, Stand Light Punch]
type = ChangeState
value = 10415
triggerall = var(49) = 10000
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = stateno = [100,105]

;Ⴊݒon
[State -1, Crouching Light Punch]
type = ChangeState
value = 10410
triggerall = var(49) = 10000
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = 10400 && time > 4
trigger3 = stateno = 10402 && time > 4
trigger4 = (stateno = 11050) && time > 18
;---------------------------------------------------------------------------
;Ⴊ݋@
[State -1, Stand Strong Punch]
type = ChangeState
value = 10422
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "z+a"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 410) && movecontact
trigger3 = stateno = 100
trigger4 = stateno = 105

;Ⴊ݋@B
[State -1, Stand Strong Punch]
type = ChangeState
value = 10422
triggerall = var(49) != 10000
triggerall = NumHelper(2) = 0 
triggerall = command = "z+a"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = (stateno = 245) && movecontact

;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = var(49) != 10000
triggerall = stateno != 100
triggerall = stateno != 105
triggerall = numhelper(2) = 0
triggerall = numhelper(11011) = 0
triggerall = command = "z"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;Ⴊ݋_bVon
[State -1, Stand Light Punch]
type = ChangeState
value = 10425
triggerall = var(49) = 10000
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = stateno = [100,105]

;Ⴊ݋on
[State -1, Crouching Light Punch]
type = ChangeState
value = 10420
triggerall = var(49) = 10000
triggerall = command = "z"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = 10410 && time > 4
trigger3 = (stateno = 11050) && time > 18
;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋
[State -1, Crouching Strong Kick]
type = ChangeState
value = 442
triggerall = var(49) != 10000
triggerall = numhelper(2) = 0
triggerall = numhelper(11011) = 0
triggerall = command = "z"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)
trigger3 = stateno = 100
trigger4 = stateno = 105

;Ⴊ݋iwCYj
[State -1, Jump Strong Punch]
type = ChangeState
value = 418
triggerall = var(49) != 10000
triggerall = command = "z"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl
;---------------------------------------------------------------------------
;󒆎
[State -1, Stand Strong Punch]
type = ChangeState
value = 10602
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "x+a"
triggerall = statetype = A
trigger1 = ctrl

;Jump Light Punch
;󒆎
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = var(49) != 10000
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;Jump Light Punch
;󒆎on
[State -1, Jump Light Punch]
type = ChangeState
value = 10600
triggerall = var(49) = 10000
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
;󒆒
[State -1, Stand Strong Punch]
type = ChangeState
value = 10612
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "y+a"
triggerall = statetype = A
trigger1 = ctrl

;󒆒iwCYLj
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = numhelper(11011) = 0
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl

;󒆒iwCYj
[State -1, Jump Strong Punch]
type = ChangeState
value = 618
triggerall = var(49) != 10000
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl

;Jump Light Punch
;󒆒on
[State -1, Jump Light Punch]
type = ChangeState
value = 10610
triggerall = var(49) = 10000
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
;󒆋
[State -1, Stand Strong Punch]
type = ChangeState
value = 10622
triggerall = var(49) != 10000
triggerall = NumHelper(11011) = 0 
triggerall = NumHelper(2) = 0 
triggerall = command = "z+a"
triggerall = statetype = A
trigger1 = ctrl

;Jump Strong Kick
;󒆋
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = numhelper(2) = 0
triggerall = var(49) != 10000
triggerall = numhelper(11011) = 0
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl

;Jump Strong Kick
;󒆋ph
[State -1, Jump Strong Kick]
type = ChangeState
value = 618
triggerall = var(49) != 10000
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl

;Jump Light Punch
;󒆋on
[State -1, Jump Light Punch]
type = ChangeState
value = 10620
triggerall = var(49) = 10000
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl
;----------------------------------------------------
[State -1,2iWv]
type = ChangeState
value = 41
;triggerall = !Ishelper	     ;vC[wp[łȂƂ
triggerall = var(49) = 10000 ;X^h[ĥƂ
triggerall = var(4) = 1      ;2iެ߉\̎Bvar(4)2iެ߂uԂOɂȂAnƂPɂȂ
triggerall = command = "up";"holdup"
triggerall = stateno = 50 || stateno = 10822;&& time >= 25
trigger1 = ctrl
triggerall = command != "upc"
;===========================================================================
;X^hij
[State -1, Taunt]
type = ChangeState
value = 10820
triggerall = numhelper(2) = 0
triggerall = numhelper(11011) = 0
triggerall = !var(49)
triggerall = var(7) = 0;X^h̂Ƃ
triggerall = roundstate = 2
triggerall = command = "a"
triggerall = statetype = S;!= A    ;S, C, A(AႪ݁A
trigger1 = NumHelper(2) = 0 
trigger1 = ctrl
ignorehitpause = 0

;X^hiႪ݁j
[State -1, Taunt]
type = ChangeState
value = 10821
triggerall = numhelper(2) = 0
triggerall = numhelper(11011) = 0
triggerall = var(7) = 0;X^h̂Ƃ
triggerall = !var(49)
triggerall = roundstate = 2
triggerall = command = "a"
triggerall = statetype = C
trigger1 = ctrl
ignorehitpause = 0

;X^hi󒆁j
[State -1, Taunt]
type = ChangeState
value = 10822
triggerall = numhelper(2) = 0
triggerall = numhelper(11011) = 0
triggerall = var(7) = 0;X^h̂Ƃ
triggerall = !var(49)
triggerall = roundstate = 2
triggerall = command = "a"
triggerall = statetype = A
trigger1 = ctrl
ignorehitpause = 0
;---------------------------------------------------------------------------
;X^hij
[State -1, Taunt]
type = ChangeState
value = 16003
triggerall = var(44) = 0
triggerall = var(49) = 10000
triggerall = roundstate = 2
triggerall = command = "a"
triggerall = statetype = S
trigger1 = ctrl
ignorehitpause = 0

;X^hiႪ݁j
[State -1, Taunt]
type = ChangeState
value = 16004
triggerall = var(44) = 0
triggerall = var(49) = 10000
triggerall = roundstate = 2
triggerall = command = "a"
triggerall = statetype = C
trigger1 = ctrl
ignorehitpause = 0

;X^hi󒆁j
[State -1, Taunt]
type = ChangeState
value = 16005
triggerall = var(44) = 0
triggerall = var(49) = 10000
triggerall = roundstate = 2
triggerall = command = "a"
triggerall = statetype = A
trigger1 = ctrl
ignorehitpause = 0